/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_41_H__
#define __REG_41_H__
/* ***********************************************************************
   *                                                                     *
   * regx41.h                                                            *
   * Tilmann Wendel , BID R&D, 12. Jan. 1998                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * non lockable actions (read from status registers)                   *
   *                                                                     *
   ***********************************************************************
*/

#include "regxdir.h"

#define MERGE_PERFACTION_NOLOCK(cmd)	CMD_MERGE (CMDG_PERFACTION_NOLOCK,cmd)

/* status read */

/* BestPerfStatusGet */
#define CMDM_PERF_STAT_READ		0x05
#define CMD_PERF_STAT_READ		MERGE_PERFACTION_NOLOCK (CMDM_PERF_STAT_READ)
#define OUT_PERF_STATUS			4
#define IN_PERF_STATUS			4

/* BestPerfCtrRead */
#define CMDM_PERF_CTR_READ		0x06
#define CMD_PERF_CTR_READ		MERGE_PERFACTION_NOLOCK (CMDM_PERF_CTR_READ)
#define OUT_PERF_CTR			4
#define IN_PERF_CTR			8

/* more to come.... */

#endif
